package com.vmware.automatic.plugin.registration.commands;

import org.apache.commons.cli.Options;

public class PluginRegistryCmdTest extends PluginCmdTest {

   void beforeEach() throws Exception {
      super.beforeEach();
   }

   @Override
   void assertOptions(Options options) {
      super.assertOptions(options);
      // name
      assertOption(options, "n", "name", "Plugin name", false, true, "name");
      // summary
      assertOption(options, "s", "summary", "Plugin summary", false, true,
            "summary");
      // company
      assertOption(options, "c", "company", "Plugin company", false, true,
            "company");
      // server thumbprint
      assertOption(options, "st", "serverThumbprint",
            "Thumbprint of the plugin server's SSL certificate.",
            false, true, "Plugin's server thumbprint");
      // showInSolutionManager
      assertOption(options, "show", "showInSolutionManager",
            "If specified the plugin will be shown in Administration panel, Solutions plug-in list",
            false);
      // remote
      assertOption(options, "remote", null,
            "If specified will register/update a remote plugin", false);
      // local
      assertOption(options, "local", null,
            "If specified will register/update a local plugin", false);
   }
}
